/*Ŀ
   ICONLOAD - Example of loading an icon  
   to a VGA display.                      
                                          
   Copyright (C) 1992 by Rimrock Software 
   All rights reserved.                   
                                          
   Compiled with Borland C++, version 3.0 
                                          
   NOTE: no attempt is made to determine  
   display adapter type.  Do not attempt  
   to run this program unless you have an 
   VGA display.                           
  */
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <string.h>

#define LINES *((unsigned char far *) 0x00000485)

        /* LINES is a pointer to a BIOS RAM variable that contains  */
        /* the current number of bytes it takes to make up a dis-   */
        /* play character.  We use this value to adjust the icon    */
        /* size as it is read in, so the icon is correctly displayed*/
        /* no matter what display font is being used.               */

/*Ŀ
   Load an icon into the display adapter
  */
void load_icon(unsigned char *chr, unsigned char_num)
{
   struct REGPACK r;
   int i;

   r.r_es = FP_SEG(chr);
   r.r_bp = FP_OFF(chr);        /* character address in ES:BP            */
   r.r_bx = LINES << 8;         /* bytes per char in BH, 0 in BL         */
   r.r_cx = 8;                  /* number of chars to load               */
   r.r_dx = char_num;           /* which char will be loaded (0-255)     */
   r.r_ax = 0x1100;             /* function 11h, subfunction 00h         */
   intr(0x10,&r);               /* go load the character                 */
}

/*Ŀ
   Display an icon generated with the   
    Rimrock Icon Editor                 
  */
void main(int argc, char *argv[])
{
   FILE *fptr;                          /* file pointer   */
   unsigned char icon_array[256];       /* icon storage   */
   char s[81];                          /* file storage   */
   int i;                               /* index variable */
   int start;

   if(argc != 2)                        /* check for command line argument */
   {
      puts("\nSyntax:\n\n   LOADICON filename.ext\n\n");
      puts("filename.ext is an icon file generated by RIE.\n\n");
      exit(1);
   }

   if((fptr = fopen(argv[1],"r")) == NULL) /* attempt to open the file */
   {
      printf("Can't open %s.\007\n",argv[1]);
      exit(2);
   }

   for(i=0; ; i++)                      /* gobble up junk lines */
   {
      fgets(s,80,fptr);
      if(strstr(s,"IcnT") == NULL)      /* look for a start to the icon */
      {
         if(i >= 11)                    /* tried long enough. bail out */
         {
            printf("\n%s is not an icon file.\007\n",argv[1]);
            exit(3);
         }
      }
      else
         break;                         /* found the start of the data */
   }

   memset(icon_array, 0, 256);

   start = ((LINES * 8) - 64) / 4;

   fscanf(fptr,"\n");
   for(i=start; i<start+8; i++)
      fscanf(fptr,"0x%x,",&icon_array[i]); /* read line 1 (0-7) */
   fscanf(fptr,"\n");
   for( ; i<start+16; i++)
      fscanf(fptr,"0x%x,",&icon_array[i]); /* read line 2 (8-15) */
   fscanf(fptr,"\n");
   for( ; i<start+24; i++)
      fscanf(fptr,"0x%x,",&icon_array[i]); /* read line 3 (16-23) */
   fscanf(fptr,"\n");
   for( ; i<start+32; i++)
      fscanf(fptr,"0x%x,",&icon_array[i]); /* read line 4 (24-31) */
   fscanf(fptr,"\n");

   start += ((LINES * 8) / 2);

   for(i = start; i<start+8; i++)
      fscanf(fptr,"0x%x,",&icon_array[i]); /* read line 5 (32-39) */
   fscanf(fptr,"\n");
   for( ; i<start+16; i++)
      fscanf(fptr,"0x%x,",&icon_array[i]); /* read line 6 (40-47) */
   fscanf(fptr,"\n");
   for( ; i<start+24; i++)
      fscanf(fptr,"0x%x,",&icon_array[i]); /* read line 7 (48-55) */
   fscanf(fptr,"\n");
   for( ; i<start+31; i++)
      fscanf(fptr,"0x%x,",&icon_array[i]); /* read line 8 (56-62) */
   fscanf(fptr,"0x%x",&icon_array[i]);     /* read line 8 (63) */
   fclose(fptr);                        /* close the file */

        /* An icon is composed of characters from the upper 128 characters */
        /* of the display set, arranged in a 2 x 4 matrix:                 */
        /*       1st 5th                                                   */
        /*       2nd 6th                                                   */
        /*       3rd 7th                                                   */
        /*       4th 8th                                                   */
        /* When displaying an icon, this is exactly how you would do it.   */
        /* (See SAMPLE.TXT for an example of laying out an icon in text.)  */
        /* Characters 192-223 (0xc0-0xdf) of the display set are special.  */
        /* In this range, the rightmost bits of each character is          */
        /* duplicated as a 9th bit.  The purpose of this is to allow you   */
        /* to create things with these characters and not have any breaks  */
        /* in what you've created. For instance, when you draw a box, the  */
        /* box will consist of continuous lines.  Since our icon consists  */
        /* of characters that are meant to be continuous, characters 1     */
        /* through 4  MUST be in the range of 192-223.  Characters 5       */
        /* through 8  MUST NOT be in this range.  For this reason, we have */
        /* chosen characters 220-223 for 1-4 and 224-227 for 5-8. This     */
        /* makes them easy to load, since you can load all 8 at once.      */
        /* To verify proper loading, run the EXAMPLE.BAT file              */

   load_icon(icon_array,0xdc);

   exit(0);                             /* and that's it, folks. */
}

